//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop
#include "Unit1.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CPort"
#pragma link "CPortCtl"
#pragma resource "*.dfm"

// (C) Fabrice Sincre ; mai 2011
// IDE : Borland Builder 5
// Composant ComPort

// Variables globales

double temperature_actuelle = 0.0;

AnsiString temoinreception = " "; // clignotement d'une toile (*) dans la bote "temprature actuelle"


unsigned char tableau[3];
        // TX (RS232)  3 octets transmis vers le PIC
        // 1er octet transmis: tableau[0]
        // 2me octet transmis : tableau[1]
        // 3me octet transmis : tableau[2]

// instruction          1er octet (code instruction)    2me octet (donnes)    3me octet (donnes)

// Read Temperature     0xAA                            0x00 non utilise       0x00 non utilise
// Read TH              0xA1                            0x00 non utilise       0x00 non utilise
// Read TL              0xA2                            0x00 non utilise       0x00 non utilise
// Write TH             0x01                            (0000000 D8)            (D7 ... D0)
// Write TL             0x02                            (0000000 D8)            (D7 ... D0)

int D[9]; // 9 bits (D[8] ... D[0]) : temprature numrique en complment  deux

int flagReadTemperature = 0; // drapeau instruction Read Temperature
int flagReadTH =0;
int flagReadTL =0;
int flagWriteTH =0;
int flagWriteTL =0;

double TH = 15.0;
double TL = 10.0;

char tabulation ='\t';  // tabulation horizontale, code ASCII 0x09
char retour ='\r';      // retour chariot, code ASCII 0x0D
char saut ='\n';        // saut  la ligne, code ASCII 0x0A
int iFileHandle;
AnsiString time0;

TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{

// lecture de la temprature toutes les 1000 ms
Timer1 -> Interval = 1000;
// mise  jour fichier de donnes toutes les 5 minutes
Timer3 -> Interval = 300000;


}


//---------------------------------------------------------------------------
void ReadTH(void)
{
// lecture TH

Form1 -> Timer1 ->Enabled =false;
if (flagReadTH ==0 && flagReadTL ==0 && flagWriteTH ==0 && flagWriteTL ==0 && flagReadTemperature ==0)
{
        tableau[0]= 0xA1;
        tableau[1]= 0x00;
        tableau[2]= 0x00;
        flagReadTH = 1;
        flagReadTL = 0;
        flagWriteTH = 0;
        flagWriteTL = 0;
        flagReadTemperature = 0;

        // transmission des 3 octets (liaison RS232)

        // 1er octet transmis: tableau[0]
        // 2me octet transmis : tableau[1]
        // 3me octet transmis : tableau[2]

        Form1->ComPort1->Write(tableau, 3); // Ecrit les 3 octets sur le port srie
}
Form1 -> Timer1 ->Enabled =true;
return;

}

//---------------------------------------------------------------------------
void ReadTL(void)
{
// lecture TL

Form1 -> Timer1 ->Enabled =false;
if (flagReadTH ==0 && flagReadTL ==0 && flagWriteTH ==0 && flagWriteTL ==0 && flagReadTemperature ==0)
{
        tableau[0]= 0xA2;
        tableau[1]= 0x00;
        tableau[2]= 0x00;
        flagReadTL = 1;
        flagReadTH = 0;
        flagWriteTH = 0;
        flagWriteTL = 0;
        flagReadTemperature = 0;
        // transmission des 3 octets (liaison RS232)

        // 1er octet transmis: tableau[0]
        // 2me octet transmis : tableau[1]
        // 3me octet transmis : tableau[2]

        Form1->ComPort1->Write(tableau, 3); // Ecrit les 3 octets sur le port srie
}
Form1 ->Timer1 ->Enabled =true;
return;
}



//---------------------------------------------------------------------------

double bintemp (int *data)
{
// conversion de (D8 ... D0) en complment  2 (tableau D[9])
// en temprature (en C)

// 0 1111 1010 = 250 = +125C (max)
// 0 0000 0001 = 1 = +0,5C
// 0 0000 0000 = 0 = 0C
// 1 1111 1111 = -1 = - 0,5 C
// 1 1001 0010 = -110 = -55C (min)

// D8 = bit de signe
// D8 = 0 : temperature positive
// D8 = 1 : temperature ngative
// 1 1001 0010
// on complmente : 0110 1101 = 109
// +1 = 110 = -55 C

double temperature;

if (data[8] == 0)
{
        temperature = 128*data[7] + 64*data[6] + 32*data[5] + 16*data[4] + 8*data[3] + 4*data[2] + 2*data[1] + data[0];
        temperature = temperature*0.5;
}
else
{
        temperature = 128*(1-data[7]) + 64*(1-data[6]) + 32*(1-data[5]) + 16*(1-data[4]) + 8*(1-data[3]) + 4*(1-data[2]) + 2*(1-data[1]) +(1- data[0]);
        temperature = - (temperature + 1)*0.5;
}

return temperature;
}

//---------------------------------------------------------------------------

void tempbin(double temperature)
{
// conversion de la temperature (en C)
// en un nombre binaire en complment  2
// (dans la variable globale D[9])

temperature = 2*temperature;
int itemperature;
itemperature = temperature;

if (itemperature >=0)
{
        D[8]=0;   // bit de signe

        for (int i=0 ; i < 8 ; i++)
        {
                D[i] = itemperature % 2 ; // reste de la division
                itemperature = itemperature /2 ;
        }
}

else
{
        D[8]=1;      // bit de signe
        itemperature = -itemperature ;
        itemperature = 256 -itemperature;
        for (int i=0 ; i < 8 ; i++)
        {
                D[i] = itemperature % 2 ; // reste de la division
                itemperature = itemperature /2 ;
        }
}

return;
}

//---------------------------------------------------------------------------



void __fastcall TForm1::Timer3Timer(TObject *Sender)
{

// mise  jour du fichier de donnes toutes les 5 minutes

///////////////////////////////////////////////
// on cre le fichier local web_temperature.txt
// (s'il existe dj, il est cras)

iFileHandle = FileCreate("web_temperature.txt");

double temperature_bak = temperature_actuelle;
AnsiString date_bak = Date();
AnsiString time_bak = Time();

FileWrite(iFileHandle, DateToStr(date_bak).c_str(), DateToStr(date_bak).Length());
FileWrite(iFileHandle, &tabulation, 1);
FileWrite(iFileHandle, TimeToStr(time_bak).c_str(), TimeToStr(time_bak).Length());
FileWrite(iFileHandle, &tabulation, 1);
FileWrite(iFileHandle, FloatToStrF(temperature_bak,ffFixed,15,1).c_str(), FloatToStrF(temperature_bak,ffFixed,15,1).Length());
FileWrite(iFileHandle, " C", 3);
FileWrite(iFileHandle, &retour, 1);
FileWrite(iFileHandle, &saut, 1);

FileClose(iFileHandle);
///////////////////////////////////////////


ListBox1->Items->Add("----------------");



try
{
// La mthode Connect connecte le client  l'hte distant.
NMFTP1->Connect();

// commande FTP : UploadAppend
// La mthode UploadAppend est utilise pour copier de l'ordinateur local
// un fichier vers l'hte FTP distant.
// Si un fichier de mme nom existe dj,
// le nouveau fichier est ajout  la fin du fichier existant.


try
{
NMFTP1->UploadAppend("web_temperature.txt", "web_temperature.txt");
}
catch(...)
{
// commande FTP : Upload
// La mthode Upload est utilise pour envoyer un fichier de l'ordinateur local vers l'hte distant.
NMFTP1->Upload("web_temperature.txt", "web_temperature.txt");
}

ListBox1->Items->Add("");
ListBox1->Items->Add(DateToStr(date_bak));
ListBox1->Items->Add(TimeToStr(time_bak));
ListBox1->Items->Add(FloatToStrF(temperature_bak,ffFixed,15,1)+" C");
ListBox1->Items->Add("");

// La mthode Disconnect dconnecte le client de l'hte distant.
NMFTP1->Disconnect();


}

catch(...)
{
}




}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button7Click(TObject *Sender)
{
ComPort1->Connected=true;  // ouverture du port
Button7->Enabled=false;
Button8->Enabled=true;
Button6->Enabled=false;

GroupBoxThermostat ->Enabled=true;

flagReadTemperature = 0; // drapeau instruction Read Temperature
flagReadTH =0;
flagReadTL =0;
flagWriteTH =0;
flagWriteTL =0;

Timer1 ->Enabled =true;
Timer3 ->Enabled =false;
GroupBox_MySQL ->Enabled =true;
Button_connexion_ftp ->Enabled = true;
Button_fermeture_ftp ->Enabled = false;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button8Click(TObject *Sender)
{
ComPort1->Connected=false;  // fermeture du port
Button7->Enabled=true;
Button8->Enabled=false;
Button6->Enabled=true;
Timer3->Enabled=false;

GroupBoxThermostat ->Enabled=false;
GroupBox_MySQL ->Enabled =false;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComPort1RxChar(TObject *Sender, int Count)
{
// on arrive ici quand on reoit des donnes du port COM

Timer1 ->Enabled =false;

/*
instruction             1er octet (donnes)     2me octet (donnes)

Read Temperature        (0000000 D8)            (D7 ... D0)
Read TH                 (0000000 D8)            (D7 ... D0)
Read TL                 (0000000 D8)            (D7 ... D0)
Write TH                0x00 (non utilis)      0x00 (non utilis)
Write TL                0x00 (non utilis)      0x00 (non utilis)
*/

try
{

unsigned char *datarecu = new unsigned char [Count];
ComPort1->Read(datarecu, Count);
// Lit "Count" octet(s) prsent(s) dans le buffer d'entre et le(s) place dans "datarecu"
// Normalement, on reoit deux octets du PIC

if (flagReadTH == 1)
{
        D[8] = datarecu[0];

        for (int i=0 ; i < 8 ; i++)
        {
                D[i] = datarecu[1] % 2 ; // reste de la division
                datarecu[1] = datarecu[1] /2 ;
        }
        EditTH ->Text =  bintemp (D);
        TH = bintemp (D);

}
else if (flagReadTL == 1)
{
        D[8] = datarecu[0];

        for (int i=0 ; i < 8 ; i++)
        {
                D[i] = datarecu[1] % 2 ; // reste de la division
                datarecu[1] = datarecu[1] /2 ;
        }
        EditTL ->Text =  bintemp (D);
        TL = bintemp (D);
}

else if (flagReadTemperature == 1)
{
        D[8] = datarecu[0];

        for (int i=0 ; i < 8 ; i++)
        {
                D[i] = datarecu[1] % 2 ; // reste de la division
                datarecu[1] = datarecu[1] /2 ;
        }
        temperature_actuelle =  bintemp (D);
       

        // tmoin de rception
        if (temoinreception == " ") temoinreception = "*";
        else temoinreception = " ";
}


else if (flagWriteTH == 1)
{
        if ((datarecu[0] != 0x00) || (datarecu[1] != 0x00))
        {
                Application->MessageBox("Erreur de rception !","Erreur 04",MB_OK);
        }

}

else if (flagWriteTL == 1)
{
        if ((datarecu[0] != 0x00) || (datarecu[1] != 0x00))
        {
                Application->MessageBox("Erreur de rception !","Erreur 05",MB_OK);
        }

}

flagReadTemperature = 0; // drapeau instruction Read Temperature
flagReadTH =0;
flagReadTL =0;
flagWriteTH =0;
flagWriteTL =0;

delete [] datarecu;
datarecu = NULL;
}

catch(...)
{
Application->MessageBox("Erreur de rception !","Erreur 06",MB_OK);
}
Timer1 ->Enabled =true;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button6Click(TObject *Sender)
{
ComPort1->ShowSetupDialog();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
// on arrive ici toutes les 1000 ms

if (ComPort1->Connected==true)
{
        // lecture de la temprature (instruction Read Temperature)
        tableau[0]= 0xAA;
        tableau[1]= 0x00;
        tableau[2]= 0x00;

        ComPort1->Write(tableau, 3); // Ecrit les 3 octets sur le port srie

        flagReadTemperature = 1;
        flagWriteTH = 0;
        flagReadTL = 0;
        flagReadTH = 0;
        flagWriteTL = 0;

}

// mise  jour affichage de la temprature actuelle + tmoin de rception clignotant
Label6temp -> Caption = FloatToStrF(temperature_actuelle,ffFixed,15,1) + " C " + temoinreception;
// affichage de l'heure courante
Label7time->Caption=TimeToStr(Time());   // AnsiString  hh:mm:ss
Label7date->Caption=DateToStr(Date());   // AnsiString

}
//---------------------------------------------------------------------------



void __fastcall TForm1::ButtonWriteTHClick(TObject *Sender)
{
// criture TH

Timer1 ->Enabled =false;
if (flagReadTH ==0 && flagReadTL ==0 && flagWriteTH ==0 && flagWriteTL ==0 && flagReadTemperature ==0)
{

try
{
double THbak = TH;
TH = EditTH ->  Text.ToDouble();

if ((TH < -55.0) || (TH > 125.0))
{
        Application->MessageBox("La temprature TH doit tre comprise\nentre -55 et +125 C","Erreur 07",MB_OK);
        EditTH ->  Text = THbak;
        TH = THbak;
        ReadTH();
        return;
}
int iTH;
iTH = 2.0*TH;

if ((2.0*TH - iTH) != 0)
{
        Application->MessageBox("La temprature TH doit tre un multiple\nde 0,5 C","Erreur 08",MB_OK);
        EditTH ->  Text = THbak;
        TH = THbak;
        ReadTH();
        return;
}
if (TL >= TH)
{
        Application->MessageBox("La temprature TL doit tre\ninfrieure  la temprature TH","Erreur 09",MB_OK);
        EditTH ->  Text = THbak;
        TH = THbak;
        ReadTH();
        return;
}
// conversion en binaire
tempbin(TH);

tableau[0]= 0x01;
tableau[1]= D[8];
tableau[2] = 128*D[7] + 64*D[6] + 32*D[5] + 16*D[4] + 8*D[3] + 4*D[2] + 2*D[1] + D[0];

flagWriteTH = 1;
flagReadTL = 0;
flagReadTH = 0;
flagWriteTL = 0;
flagReadTemperature = 0;
// transmission des 3 octets (liaison RS232)

// 1er octet transmis: tableau[0]
// 2me octet transmis : tableau[1]
// 3me octet transmis : tableau[2]

ComPort1->Write(tableau, 3); // Ecrit les 3 octets sur le port srie
}
catch(...)
{
Application->MessageBox("Valeur non valide !","Erreur 10",MB_OK);

}
}

Timer1 ->Enabled =true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonWriteTLClick(TObject *Sender)
{
// criture TL

Timer1 ->Enabled =false;
if (flagReadTH ==0 && flagReadTL ==0 && flagWriteTH ==0 && flagWriteTL ==0 && flagReadTemperature ==0)
{

try
{

double TLbak = TL;
TL = EditTL ->  Text.ToDouble();

if ((TL < -55.0) || (TL > 125.0))
{
        Application->MessageBox("La temprature TL doit tre comprise\nentre -55 et +125 C","Erreur 11",MB_OK);
        EditTL ->  Text = TLbak;
        TL = TLbak;
        ReadTL();
        return;
}
int iTL;
iTL = 2.0*TL;

if ((2.0*TL - iTL) != 0)
{
        Application->MessageBox("La temprature TL doit tre un multiple\nde 0,5 C","Erreur 12",MB_OK);
        EditTL ->  Text = TLbak;
        TL = TLbak;
        ReadTL();
        return;
}
if (TL >= TH)
{
        Application->MessageBox("La temprature TL doit tre\ninfrieure  la temprature TH","Erreur 13",MB_OK);
        EditTL ->  Text = TLbak;
        TL = TLbak;
        ReadTL();
        return;
}

// conversion en binaire
tempbin(TL);

tableau[0]= 0x02;
tableau[1]= D[8];
tableau[2] = 128*D[7] + 64*D[6] + 32*D[5] + 16*D[4] + 8*D[3] + 4*D[2] + 2*D[1] + D[0];

flagWriteTL = 1;
flagReadTH =0;
flagReadTL =0;
flagWriteTH =0;
flagReadTemperature = 0;

// transmission des 3 octets (liaison RS232)

// 1er octet transmis: tableau[0]
// 2me octet transmis : tableau[1]
// 3me octet transmis : tableau[2]

ComPort1->Write(tableau, 3); // Ecrit les 3 octets sur le port srie
}
catch(...)
{
Application->MessageBox("Valeur non valide !","Erreur 14",MB_OK);
}
}
Timer1 ->Enabled =true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonReadTHClick(TObject *Sender)
{
ReadTH();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonReadTLClick(TObject *Sender)
{
ReadTL();
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button_connexion_ftpClick(TObject *Sender)
{

///////////////////////////////////////////////
// on cre le fichier local web_temperature.txt
// (s'il existe dj, il est cras)

iFileHandle = FileCreate("web_temperature.txt");

double temperature_bak = temperature_actuelle;
AnsiString date_bak = Date();
AnsiString time_bak = Time();

FileWrite(iFileHandle, DateToStr(date_bak).c_str(), DateToStr(date_bak).Length());
FileWrite(iFileHandle, &tabulation, 1);
FileWrite(iFileHandle, TimeToStr(time_bak).c_str(), TimeToStr(time_bak).Length());
FileWrite(iFileHandle, &tabulation, 1);
FileWrite(iFileHandle, FloatToStrF(temperature_bak,ffFixed,15,1).c_str(), FloatToStrF(temperature_bak,ffFixed,15,1).Length());
FileWrite(iFileHandle, " C", 3);
FileWrite(iFileHandle, &retour, 1);
FileWrite(iFileHandle, &saut, 1);

FileClose(iFileHandle);
///////////////////////////////////////////

ListBox1->Items->Add("----------------");


NMFTP1->Host = Edit_host->Text;
NMFTP1->Port = StrToInt(Edit_port->Text);
NMFTP1->UserID = Edit_user->Text;
NMFTP1->Password = Edit_password ->Text;

try
{
// La mthode Connect connecte le client  l'hte distant.
NMFTP1->Connect();

NMFTP1->ChangeDir("/");   // on se place dans la racine


// commande FTP : UploadAppend
// La mthode UploadAppend est utilise pour copier de l'ordinateur local
// un fichier vers l'hte FTP distant.
// Si un fichier de mme nom existe dj,
// le nouveau fichier est ajout  la fin du fichier existant.


try
{
NMFTP1->UploadAppend("web_temperature.txt", "web_temperature.txt");
}
catch(...)
{
// commande FTP : Upload
// La mthode Upload est utilise pour envoyer un fichier de l'ordinateur local vers l'hte distant.
NMFTP1->Upload("web_temperature.txt", "web_temperature.txt");
}

ListBox1->Items->Add("");
ListBox1->Items->Add(DateToStr(date_bak));
ListBox1->Items->Add(TimeToStr(time_bak));
ListBox1->Items->Add(FloatToStrF(temperature_bak,ffFixed,15,1)+" C");
ListBox1->Items->Add("");

// La mthode Disconnect dconnecte le client de l'hte distant.
NMFTP1->Disconnect();


Button_connexion_ftp ->Enabled = false;
Button_fermeture_ftp ->Enabled = true;
Timer3 ->Enabled =true;
}

catch(...)
{
Button_connexion_ftp ->Enabled = true;
Button_fermeture_ftp ->Enabled = false;
Timer3 ->Enabled =false;


}


}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button_fermeture_ftpClick(TObject *Sender)
{
Timer3 ->Enabled =false;
Button_connexion_ftp ->Enabled = true;
Button_fermeture_ftp ->Enabled = false;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button_clearClick(TObject *Sender)
{
ListBox1->Items->Clear();
}
//---------------------------------------------------------------------------





void __fastcall TForm1::NMFTP1Connect(TObject *Sender)
{
//
ListBox1->Items->Add("Connected");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1ConnectionFailed(TObject *Sender)
{
// 
ListBox1->Items->Add("Connection Failed");       
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1Disconnect(TObject *Sender)
{
//     
ListBox1->Items->Add("Disconnected");   
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1Error(TComponent *Sender, WORD Errno,
      AnsiString Errmsg)
{
//        
ListBox1->Items->Add("Error "+IntToStr(Errno)+" : "+Errmsg);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1Failure(bool &Handled, TCmdType Trans_Type)
{
//
  switch (Trans_Type) {
    case cmdChangeDir: ListBox1->Items->Add("ChangeDir failure"); break;
    case cmdMakeDir: ListBox1->Items->Add("MakeDir failure"); break;
    case cmdDelete: ListBox1->Items->Add("Delete failure"); break;
    case cmdRemoveDir: ListBox1->Items->Add( "RemoveDir failure"); break;
    case cmdList: ListBox1->Items->Add("List failure"); break;
    case cmdRename: ListBox1->Items->Add("Rename failure"); break;
    case cmdUpRestore: ListBox1->Items->Add("UploadRestore failure"); break;
    case cmdDownRestore: ListBox1->Items->Add("DownloadRestore failure"); break;
    case cmdDownload: ListBox1->Items->Add("Download failure"); break;
    case cmdUpload: ListBox1->Items->Add( "Upload failure"); break;
    case cmdAppend: ListBox1->Items->Add( "UploadAppend failure"); break;
    case cmdReInit: ListBox1->Items->Add( "ReInit failure"); break;
    case cmdAllocate: ListBox1->Items->Add( "Allocate failure"); break;
    case cmdNList: ListBox1->Items->Add( "NList failure"); break;
    case cmdDoCommand: ListBox1->Items->Add( "DoCommand failure"); break;
	default: ListBox1->Items->Add("Unrecognized command failed."); break;
  }
   
   
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1HostResolved(TComponent *Sender)
{
//     
ListBox1->Items->Add("Host Resolved");   
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1InvalidHost(bool &Handled)
{
//

ListBox1->Items->Add("Invalid host");
 
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1ListItem(AnsiString Listing)
{
//     
ListBox1->Items->Add(Listing);   
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1PacketRecvd(TObject *Sender)
{
//      
ListBox1->Items->Add(IntToStr(NMFTP1->BytesRecvd)+" bytes of "+IntToStr(NMFTP1->BytesTotal)+" received");  
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1PacketSent(TObject *Sender)
{
//
ListBox1->Items->Add(IntToStr(NMFTP1->BytesSent)+" bytes of "+IntToStr(NMFTP1->BytesTotal)+" sent");             
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1Status(TComponent *Sender, AnsiString Status)
{
//       
ListBox1->Items->Add(Status); 
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1Success(TCmdType Trans_Type)
{
//   
  switch(Trans_Type)
  {
    case cmdChangeDir: ListBox1->Items->Add( "ChangeDir success"); break;
    case cmdMakeDir: ListBox1->Items->Add( "MakeDir success"); break;
    case cmdDelete: ListBox1->Items->Add( "Delete success"); break;
    case cmdRemoveDir: ListBox1->Items->Add( "RemoveDir success"); break;
    case cmdList: ListBox1->Items->Add( "List success"); break;
    case cmdRename: ListBox1->Items->Add( "Rename success"); break;
    case cmdUpRestore: ListBox1->Items->Add( "UploadRestore success"); break;
    case cmdDownRestore: ListBox1->Items->Add( "DownloadRestore success"); break;
    case cmdDownload: ListBox1->Items->Add( "Download success"); break;
    case cmdUpload: ListBox1->Items->Add( "Upload success"); break;
    case cmdAppend: ListBox1->Items->Add( "UploadAppend success"); break;
    case cmdReInit: ListBox1->Items->Add( "ReInit success"); break;
    case cmdAllocate: ListBox1->Items->Add( "Allocate success"); break;
    case cmdNList: ListBox1->Items->Add("NList success"); break;
    case cmdDoCommand: ListBox1->Items->Add( "DoCommand success"); break;
  }  
   
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1TransactionStart(TObject *Sender)
{
//     
ListBox1->Items->Add("Starting data transaction");   
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1TransactionStop(TObject *Sender)
{
//      
ListBox1->Items->Add("Transaction Complete");  
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NMFTP1UnSupportedFunction(TCmdType Trans_Type)
{
//
 switch(Trans_Type)
  {
    case cmdChangeDir: ListBox1->Items->Add("ChangeDir not supported"); break;
    case cmdMakeDir: ListBox1->Items->Add("MakeDir not supported"); break;
    case cmdDelete: ListBox1->Items->Add("Delete not supported"); break;
    case cmdRemoveDir: ListBox1->Items->Add("RemoveDir not supported"); break;
    case cmdList: ListBox1->Items->Add("List not supported"); break;
    case cmdRename: ListBox1->Items->Add("Rename not supported"); break;
    case cmdUpRestore: ListBox1->Items->Add("UploadRestore not supported"); break;
    case cmdDownRestore: ListBox1->Items->Add("DownloadRestore not supported"); break;
    case cmdDownload: ListBox1->Items->Add("Download not supported"); break;
    case cmdUpload: ListBox1->Items->Add("Upload not supported"); break;
    case cmdAppend: ListBox1->Items->Add("UploadAppend not supported");break;
    case cmdReInit: ListBox1->Items->Add("ReInit not supported"); break;
    case cmdAllocate: ListBox1->Items->Add("Allocate not supported"); break;
    case cmdNList: ListBox1->Items->Add("NList not supported"); break;
    case cmdDoCommand: ListBox1->Items->Add("DoCommand not supported"); break;
  }

}
//---------------------------------------------------------------------------



