% bode.m

% On efface la fentre de commande
clc;

disp('Ce script Matlab permet de tracer les diagrammes de Bode.') ;
disp('Il ncessite le fichier trans.m (fichier de dfinition de la fonction de transfert).') ;


disp('Gamme de frquences :') ;
fmin=input('f min (en Hz)=? ') ;
fmax=input('f max (en Hz)=? ') ;

% nombre de points
n=input('Nombre de points =? ');

logf=log10(fmin):(log10(fmax)-log10(fmin))/n:log10(fmax) ;
f=10.^logf ;
w=2.*pi.*f ;

G = 20.*log10 (abs (trans(w)) ) ;

semilogx ( f , G ) ;
ylabel ( 'Gain (en dB)' ) ;
xlabel ( 'Frquence (en Hz)' ) ;
title ( 'Diagramme de Bode du gain' ) ;
grid on ;

dephasage = angle(trans(w))*180/pi;

figure ;
semilogx ( f , dephasage );
ylabel ( 'Dphasage (en degrs)' ) ;
xlabel ( 'Frquence (en Hz)' ) ;
title ( 'Diagramme de Bode du dphasage' ) ;
grid on ;

disp('Figure 1 -> gain en fonction de la frquence') ;

disp('Figure 2 -> dphasage en fonction de la frquence') ;

% (C) Fabrice Sincre
% http://perso.orange.fr/fabrice.sincere/

