% bodenum.m

% On efface la fentre de commande
clc;

disp('Ce script Matlab permet de tracer les diagrammes de Bode d''un filtre numrique.') ;
disp('Il ncessite le fichier transnum.m (fichier de dfinition de la fonction de transfert en z).') ;


disp('Gamme de frquences :') ;
disp('Fe : frquence d''chantillonnage') ;
fmin=input('f min / Fe =? ') ;
fmax=input('f max / Fe =? ') ;

% nombre de points
n=input('Nombre de points =? ');

logf=log10(fmin):(log10(fmax)-log10(fmin))/n:log10(fmax) ;
% f = frquence relative
f=10.^logf ;
w=2.*pi.*f ;
z=exp(j.*w);

% Amplification
A = abs (transnum(z));
% Gain en dB
G = 20.*log10 (A) ;

semilogx ( f , G ) ;
ylabel ( 'Gain (en dB)' ) ;
xlabel ( 'Frquence / Frquence d''chantillonnage' ) ;
title ( 'Diagramme de Bode du gain' ) ;
grid on ;
zoom ;
disp('Figure 1 -> Diagramme de Bode du gain') ;


dephasage = angle(transnum(z))*180/pi;

figure ;
semilogx ( f , dephasage );
ylabel ( 'Dphasage (en degrs)' ) ;
xlabel ( 'Frquence / Frquence d''chantillonnage' ) ;
title ( 'Diagramme de Bode du dphasage' ) ;
grid on ;
zoom ;
disp('Figure 2 -> Diagramme de Bode du dphasage') ;

figure;
plot (f,A);
ylabel ( 'Amplification' ) ;
xlabel ( 'Frquence / Frquence d''chantillonnage' ) ;
title ( 'Amplification en fonction de la frquence' ) ;
grid on ;
zoom ;
disp('Figure 3 -> Amplification en fonction de la frquence') ;

figure ;
plot ( f , dephasage );
ylabel ( 'Dphasage (en degrs)' ) ;
xlabel ( 'Frquence / Frquence d''chantillonnage' ) ;
title ( 'Dphasage en fonction de la frquence' ) ;
grid on ;
zoom ;
disp('Figure 4 -> Dphasage en fonction de la frquence') ;

% (C) Fabrice Sincre
% http://perso.orange.fr/fabrice.sincere/

